  OPTION EXPLICIT
  OPTION BASE 0
  DIM INTEGER TOUCH_X0,TOUCH_Y0,TOUCH_X1,TOUCH_Y1,ROTATION
  TOUCH_X0=110
  TOUCH_Y0=1993
  TOUCH_X1=2001
  TOUCH_Y1=76
  ROTATION=2    'mapped to work in rotation 2! don't change
  
  DIM INTEGER BUCKET,CFUNADD,X,Y,Z
  DIM FLOAT XIN(4),YIN(4)
  CFUNADD=peek(cfunaddr ILI9488_SPI)
  SPI OPEN 20000000, 0, 8
  SETPIN 2,DOUT
  SETPIN 23,DOUT
  SETPIN 6,DOUT
  SETPIN 7,DOUT
  BUCKET = ILI9488_SPI(CFUNADD,ROTATION)
  
  DIM INTEGER XF,YF,COUNT,N
  cls(RGB(BLACK))
  TEXT MM.HRES\2,0,"Press the Crosshairs",CT,1,2,RGB(WHITE),RGB(BLACK)
  PRINT "RAW COORDINATES:"
  FOR N= 0 to 3
    COUNT=0
    XIN(N)=0
    YIN(N)=0
    XF=1
    YF=1
    IF N = 1 OR N = 3 THEN XF=3
    IF N = 2 OR N = 3 THEN YF=3
    CROSS(MM.HRES*XF\4, MM.VRES*YF\4,40,RGB(WHITE))
    DO WHILE(COUNT<100)
      X=XPT2046(2)
      Y=XPT2046(3)
      Z=XPT2046(4)
      if (Z>40) THEN
        XIN(N)=XIN(N)+X
        YIN(N)=YIN(N)+Y
        COUNT=COUNT+1
      ENDIF
    LOOP
    XIN(N)=XIN(N)/COUNT
    YIN(N)=YIN(N)/COUNT
    CROSS(MM.HRES*XF\4, MM.VRES*YF\4,40,RGB(BLACK))
    PAUSE 100
    DO WHILE (XPT2046(4)>20)    ''await release
      PAUSE 10
    LOOP
    PAUSE 100
    PRINT XIN(N),YIN(N)
  NEXT N
  TOUCH_X0 = INT((3*(XIN(1)+XIN(3))-(XIN(0)+XIN(2)))/4)
  TOUCH_X1 = INT((3*(XIN(0)+XIN(2))-(XIN(1)+XIN(3)))/4)
  TOUCH_Y0 = INT((3*(YIN(0)+YIN(1))-(YIN(2)+YIN(3)))/4)
  TOUCH_Y1 = INT((3*(YIN(2)+YIN(3))-(YIN(0)+YIN(1)))/4)
  PRINT "CALIBRATION CONSTANTS:"
  PRINT "TOUCH_X0=";TOUCH_X0
  PRINT "TOUCH_X1=";TOUCH_X1
  PRINT "TOUCH_Y0=";TOUCH_Y0
  PRINT "TOUCH_Y1=";TOUCH_Y1
  
  cls(RGB(BLACK))
  TEXT MM.HRES\2,0,"Draw to test",CT,1,2,RGB(WHITE),RGB(BLACK)
  TEXT MM.HRES\2,30,"See console for calibration",CT,1,2,RGB(WHITE),RGB(BLACK)
  
  DO
    X=XPT2046(0,ROTATION,TOUCH_X0,TOUCH_Y0,TOUCH_X1,TOUCH_Y1,MM.HRES,MM.VRES)
    Y=XPT2046(1,ROTATION,TOUCH_X0,TOUCH_Y0,TOUCH_X1,TOUCH_Y1,MM.HRES,MM.VRES)
    if (X>-1) AND (Y>-1) THEN
      PIXEL X,Y,RGB(WHITE)
    ENDIF
  LOOP
  
  
  
  'cls
SUB CROSS(X AS INTEGER, Y AS INTEGER, D AS INTEGER, C AS INTEGER)
  LINE X,Y+D,X,Y-D,1,C
  LINE X+D,Y,X-D,Y,1,C
END SUB
  
CFunction XPT2046
  00000139
  'spi_data
  308400FF 3C02BF80 8C435810 7C033184 AC435810 00401821 8C625810 30420800
  1440FFFD 3C02BF80 AC445820 3C03BF80 8C625810 30420800 1440FFFD 00000000
  8C625810 30420001 1040FFF9 3C02BF80 8C425820 03E00008 304200FF
  'spi_data16
  27BDFFE0 AFBF001C AFB10018 AFB00014 00808821 7C843A00 0411FFE2 00000000
  00028200 322400FF 0411FFDE 00000000 02021025 8FBF001C 8FB10018 8FB00014
  03E00008 27BD0020
  'touchraw
  27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 309200FF 3C02BF88 8C436130
  7C0318C4 AC436130 02402021 0411FFCB 00000000 24100010 00008821 02402021
  0411FFDD 00000000 2610FFFF 1600FFFB 02228821 3C02BF88 8C436130 24040001
  7C8318C4 AC436130 00111FC3 00111203 8FBF001C 8FB20018 8FB10014 8FB00010
  03E00008 27BD0020
  'map
  8FA20010 00471023 00852023 70441002 00C52823 0045001A 00A001F4 00001012
  03E00008 00471021
  'touchx
  27BDFFC8 AFBF0034 AFB60030 AFB5002C AFB40028 AFB30024 AFB20020 AFB1001C
  AFB00018 00C08021 8FB30048 8FB50050 8FB40058 8FB20060 8FB60064 7C048C20
  240400B1 0411FFC2 00000000 2842000A 2404FFFF 14400050 2405FFFF 24020001
  5622000E 24020002 240400D1 0411FFB8 00000000 2643FFFF AFA30010 00402021
  02802821 02603021 00003821 0411FFD2 00000000 10000020 24030004 1622000E
  24030003 24040091 0411FFA9 00000000 2643FFFF AFA30010 00402021 02A02821
  02003021 00003821 0411FFC3 00000000 1000001F 2404FFFF 1623000E 2402FFFF
  240400D1 0411FF9A 00000000 2643FFFF AFA30010 00402021 02602821 02803021
  00003821 0411FFB4 00000000 10000010 2404FFFF 24030004 1623000D 2404FFFF
  24040091 0411FF8A 00000000 2643FFFF AFA30010 00402021 02002821 02A03021
  00003821 0411FFA4 00000000 2404FFFF 04400011 2405FFFF 00402021 00022FC3
  2642FFFF 0052902B 26D6FFFF 0256B021 02C5182A 54600007 2404FFFF 54B60007
  00801021 0044102B 10400004 00801021 2404FFFF 2405FFFF 00801021 00A01821
  8FBF0034 8FB60030 8FB5002C 8FB40028 8FB30024 8FB20020 8FB1001C 8FB00018
  03E00008 27BD0038
  'touchy
  27BDFFC8 AFBF0034 AFB60030 AFB5002C AFB40028 AFB30024 AFB20020 AFB1001C
  AFB00018 00C08021 8FB50048 8FB30050 8FB40058 8FB20068 8FB6006C 7C048C20
  240400B1 0411FF50 00000000 2842000A 2404FFFF 14400050 2405FFFF 24020001
  5622000E 24020002 24040091 0411FF46 00000000 2643FFFF AFA30010 00402021
  02602821 02003021 00003821 0411FF60 00000000 10000020 24030004 1622000E
  24030003 240400D1 0411FF37 00000000 2643FFFF AFA30010 00402021 02A02821
  02803021 00003821 0411FF51 00000000 1000001F 2404FFFF 1623000E 2402FFFF
  24040091 0411FF28 00000000 2643FFFF AFA30010 00402021 02002821 02603021
  00003821 0411FF42 00000000 10000010 2404FFFF 24030004 1623000D 2404FFFF
  240400D1 0411FF18 00000000 2643FFFF AFA30010 00402021 02802821 02A03021
  00003821 0411FF32 00000000 2404FFFF 04400011 2405FFFF 00402021 00022FC3
  2642FFFF 0052902B 26D6FFFF 0256B021 02C5182A 54600007 2404FFFF 54B60007
  00801021 0044102B 10400004 00801021 2404FFFF 2405FFFF 00801021 00A01821
  8FBF0034 8FB60030 8FB5002C 8FB40028 8FB30024 8FB20020 8FB1001C 8FB00018
  03E00008 27BD0038
  'main
  27BDFFA0 AFBF005C AFBE0058 AFB70054 AFB60050 AFB5004C AFB40048 AFB30044
  AFB20040 AFB1003C AFB00038 00808021 00A09821 00C09021 00E08821 8FB50070
  8FB60074 8FB70078 8FBE007C 3C02BF80 8C545830 2403000D AC435830 8C820000
  8C830004 00431025 2404FFFF 1440001C 2405FFFF 82640000 8CC60000 8E470004
  8E220000 8E230004 AFA20010 AFA30014 8EA20000 8EA30004 AFA20018 AFA3001C
  8EC20000 8EC30004 AFA20020 AFA30024 8EE20000 8EE30004 AFA20028 AFA3002C
  8FC20000 8FC30004 AFA20030 AFA30034 0411FEE7 00000000 00402021 00602821
  8E030000 24020001 14620021 24020002 8E020004 1440001E 24020002 82640000
  8E460000 8E470004 8E220000 8E230004 AFA20010 AFA30014 8EA20000 8EA30004
  AFA20018 AFA3001C 8EC20000 8EC30004 AFA20020 AFA30024 8EE20000 8EE30004
  AFA20028 AFA3002C 8FC20000 8FC30004 AFA20030 AFA30034 0411FF37 00000000
  00402021 00602821 8E030000 24020002 5462000A 8E030000 8E020004 54400007
  8E030000 24040091 0411FE8D 00000000 00402021 00602821 8E030000 24020003
  5462000A 8E030000 8E020004 54400007 8E030000 240400D1 0411FE81 00000000
  00402021 00602821 8E030000 24020004 1462000A 3C02BF80 8E020004 14400007
  3C02BF80 240400B1 0411FE75 00000000 00402021 00602821 3C02BF80 AC545830
  00801021 00A01821 8FBF005C 8FBE0058 8FB70054 8FB60050 8FB5004C 8FB40048
  8FB30044 8FB20040 8FB1003C 8FB00038 03E00008 27BD0060
End CFunction
  
  
  
  
CFunction ILI9488_SPI
  00000274
  'delay
  00041900 00042180 00641821 00031080 00621821 00031100 00431823 18600005
  00001021 00000040 24420001 1443FFFD 00000000 03E00008 00000000
  'lcd_data
  308400FF 3C03BF80 8C625810 30420800 1440FFFD 3C02BF80 AC445820 03E00008
  00000000
  'lcd_cmd
  308400FF 3C03BF80 8C625810 30420800 1440FFFD 3C02BF88 8C436030 7C030004
  AC436030 3C02BF80 AC445820 3C03BF80 8C625810 30420800 1440FFFD 3C02BF88
  8C436030 24040001 7C830004 AC436030 03E00008 00000000
  'lcd_rotation
  27BDFFD8 AFBF0024 AFB30020 AFB2001C AFB10018 AFB00014 00808021 3C029D00
  8C42008C 8C520000 16400008 00A08821 3C139D00 8E62003C 0040F809 24040100
  00409021 8E62008C AC520000 3C02BF88 8C436130 7C031084 AC436130 24020001
  1602000F 24020002 1620000D 24040036 0411FFCD 00000000 24040058 0411FFC1
  00000000 24020001 AE420000 24020140 AE420004 240201E0 10000021 AE420008
  1602000F 24020003 1620000D 24040036 0411FFBD 00000000 24040038 0411FFB1
  00000000 24020002 AE420000 240201E0 AE420004 24020140 10000021 AE420008
  16020010 24020004 1620000E 24040036 0411FFAD 00000000 24040098 0411FFA1
  00000000 24020003 AE420000 24020140 AE420004 240201E0 10000011 AE420008
  24020004 1602000F 3C03BF80 1620000D 24040036 0411FF9C 00000000 240400F8
  0411FF90 00000000 24020004 AE420000 240201E0 AE420004 24020140 AE420008
  3C03BF80 8C625810 30420800 1440FFFD 3C02BF88 8C436130 24040001 7C831084
  AC436130 8FBF0024 8FB30020 8FB2001C 8FB10018 8FB00014 03E00008 27BD0028
  'lcd_init
  27BDFFE0 AFBF001C AFB10018 AFB00014 3C10BF88 8E026130 7C026304 AE026130
  8E026130 24110001 7E227BC4 AE026130 24040064 0411FF5C 00000000 8E026130
  7E226304 AE026130 24040028 0411FF56 00000000 8E026130 7C021084 AE026130
  24040001 0411FF68 00000000 24040078 0411FF4D 00000000 24040011 0411FF62
  00000000 24040078 0411FF47 00000000 24040013 0411FF5C 00000000 24040020
  0411FF59 00000000 24040028 0411FF56 00000000 24040038 0411FF53 00000000
  240400C0 0411FF50 00000000 24040017 0411FF44 00000000 24040015 0411FF41
  00000000 240400C1 0411FF47 00000000 24040041 0411FF3B 00000000 240400C5
  0411FF41 00000000 2404000E 0411FF35 00000000 2404000E 0411FF32 00000000
  2404003A 0411FF38 00000000 24040066 0411FF2C 00000000 240400B4 0411FF32
  00000000 24040002 0411FF26 00000000 240400B6 0411FF2C 00000000 24040002
  0411FF20 00000000 24040002 0411FF1D 00000000 2404003B 0411FF1A 00000000
  24040029 0411FF20 00000000 2404002A 0411FF1D 00000000 00002021 0411FF11
  00000000 00002021 0411FF0E 00000000 24040001 0411FF0B 00000000 2404003F
  0411FF08 00000000 2404002B 0411FF0E 00000000 00002021 0411FF02 00000000
  00002021 0411FEFF 00000000 24040001 0411FEFC 00000000 240400DF 0411FEF9
  00000000 3C03BF80 8C625810 30420800 1440FFFD 3C02BF88 8C436130 24040001
  7C831084 AC436130 24040001 00002821 0411FF0B 00000000 8FBF001C 8FB10018
  8FB00014 03E00008 27BD0020
  'lcd_getwidth
  3C029D00 8C42008C 8C420000 2404FFFF 10400003 2405FFFF 8C440004 00042FC3
  00801021 03E00008 00A01821
  'lcd_getheight
  3C029D00 8C42008C 8C420000 2404FFFF 10400003 2405FFFF 8C440008 00042FC3
  00801021 03E00008 00A01821
  'lcd_getrotation
  3C029D00 8C42008C 8C420000 2404FFFF 10400003 2405FFFF 8C440000 00042FC3
  00801021 03E00008 00A01821
  'lcd_setarea
  27BDFFD8 AFBF0024 AFB30020 AFB2001C AFB10018 AFB00014 00808021 00C09021
  8FB10038 8FA3003C 8FB30040 0065202A 14800006 8FA20044 14A30008 0047182A
  0230182B 10600005 0047182A 02001821 02208021 00608821 0047182A 54600007
  02401021 14E20008 3C02BF88 0272102B 10400005 3C02BF88 02401021 02609021
  00409821 3C02BF88 8C436130 7C031084 AC436130 2404002A 0411FEA7 00000000
  7E043A00 0411FE9B 00000000 320400FF 0411FE98 00000000 7E243A00 0411FE95
  00000000 322400FF 0411FE92 00000000 2404002B 0411FE98 00000000 7E443A00
  0411FE8C 00000000 324400FF 0411FE89 00000000 7E643A00 0411FE86 00000000
  326400FF 0411FE83 00000000 2404002C 0411FE89 00000000 3C03BF80 8C625810
  30420800 1440FFFD 3C02BF88 8C436130 24040001 7C831084 AC436130 8FBF0024
  8FB30020 8FB2001C 8FB10018 8FB00014 03E00008 27BD0028
  'lcd_box
  27BDFFC8 AFBF0034 AFB40030 AFB3002C AFB20028 AFB10024 AFB00020 00808021
  00A09021 00C09821 00E08821 00C4102A 10400003 8FB40048 00C08021 00809821
  0232102A 10400004 AFB30010 02401021 02209021 00408821 001317C3 AFA20014
  AFB10018 001117C3 AFA2001C 02002021 00102FC3 02403021 00123FC3 0411FF8A
  00000000 26310001 02328823 26730001 02708023 72308802 3C02BF88 8C436130
  7C031084 AC436130 1A200012 3C03BF80 7E923C00 7E933A00 00008021 329400FF
  02402021 0411FE3D 00000000 02602021 0411FE3A 00000000 02802021 0411FE37
  00000000 26100001 1611FFF6 02402021 3C03BF80 8C625810 30420800 1440FFFD
  3C02BF88 8C436130 24040001 7C831084 AC436130 8FBF0034 8FB40030 8FB3002C
  8FB20028 8FB10024 8FB00020 03E00008 27BD0038
  'lcd_bitmap
  27BDFF88 AFBF0074 AFBE0070 AFB7006C AFB60068 AFB50064 AFB40060 AFB3005C
  AFB20058 AFB10054 AFB00050 00A01021 00C0B021 AFA70084 8FB40088 8FBE0094
  24050080 AFA50020 24050040 AFA50024 24050020 AFA50028 24050010 AFA5002C
  24050008 AFA50030 24050004 AFA50034 24050002 AFA50038 24050001 AFA5003C
  2485FFFF 72863002 00C52821 AFA50010 00052FC3 AFA50014 2445FFFF 72873002
  00C52821 AFA50018 00052FC3 AFA5001C 00042FC3 00403021 00023FC3 0411FF2D
  00000000 3C02BF88 8C436130 7C031084 AC436130 8FA70084 18E0003A 0000B821
  AFB60048 10000033 AFA00044 02B71021 24430007 28440000 0044180A 000318C3
  03C31821 90730000 30420007 00021080 27A30020 00621021 8C420000 02629824
  8FA5008C 8FA60090 00D3280A 7CB13C00 7CB23A00 00008021 30B300FF 02202021
  0411FDD1 00000000 02402021 0411FDCE 00000000 02602021 0411FDCB 00000000
  26100001 1614FFF6 02202021 26B50001 16B6FFDF 02B71021 8FA70040 24E70001
  10F40005 AFA70040 1EC0FFD8 0000A821 1000FFFA 8FA70040 8FA20044 24420001
  AFA20044 8FA30048 8FA50084 10450005 02E3B821 1E80FFF4 AFA00040 1000FFF7
  8FA20044 3C02BF80 8C435810 30630800 1460FFFD 00000000 3C02BF88 8C436130
  24040001 7C831084 AC436130 8FBF0074 8FBE0070 8FB7006C 8FB60068 8FB50064
  8FB40060 8FB3005C 8FB20058 8FB10054 8FB00050 03E00008 27BD0078
  'main
  27BDFFE0 AFBF001C AFB10018 AFB00014 00808821 00A08021 0411FE1B 00000000
  8E040000 8E050004 0411FDAF 00000000 3C029D00 244209D0 3C039D00 24630680
  0062202B 10800004 00621823 8E240000 10000003 00642821 8E240000 00642821
  3C039D00 246307B4 0062202B 10800004 00621023 8E240000 10000003 00441021
  8E240000 00441021 3C119D00 8E240048 AC850000 8E24004C AC820000 8E300094
  0411FE8C 00000000 AE020000 8E300098 0411FE93 00000000 AE020000 8FBF001C
  8FB10018 8FB00014 03E00008 27BD0020
End CFunction
  
  

